clear all
set matsize 10000
set maxvar 50000
set more off

cd "IRI data"

*** Program to estimate coffee prices (including heterogeneity by brand)

	import delimited "coffee_panel.csv"
	drop f d pr year qtrid
	drop if form == "K CUPS" | form == "POD" | package == "CUP IN BOX"
	drop if l2 == "COFFEE SUBSTITUTES" | l2 == "COFFEE ADDITIVE/FLAVORING" | l2 == "SINGLE CUP COFFEE"
	drop form package

** Setup
	rename iri_key stores
	rename week weekid
	replace weekid = weekid - 1113
	egen upc = group(colupc)
	egen id = group(stores upc)
	drop colupc
	xtset id weekid
	
	rename stores iri_key
	merge m:1 iri_key using stores_market.dta
	keep if _merge==3
	drop _merge
	rename iri_key stores
	encode market, gen(mkt)
	drop market

** Restrict sample
	by upc, sort: egen min = min(weekid)
	by upc, sort: egen max = max(weekid)
	gen T = max-min
	drop if T < 26
	
	qui unique stores, by(upc) gen(N)
	drop if N < 5 & strpos(product,"PRIVATE LABEL")==0
	
	drop min max T N

** Create WM post-entry and entry week indicator
	rename stores iri_key
	merge m:1 iri_key using entries_wide_11.dta
	drop if _merge==2
	drop _merge
	rename iri_key stores

	rename wmid* idwm*
	drop idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		capture drop week`i'
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	drop wm1-enter12

	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	drop dis*
	compress
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
	drop name
	compress
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
*	by stores, sort: egen wm0 = min(wm)
	
*	gen wm_diff = treat_nwm - wm0

** Brands
*	tab product

	gen private = (strpos(product,"PRIVATE LABEL")>0)
	gen folgers = (strpos(product,"FOLGERS")>0)
	gen maxwell = (strpos(product,"MAXWELL HOUSE")>0)
	gen starbucks = (strpos(product,"STARBUCKS")>0)
	gen millstone = (strpos(product,"MILLSTONE")>0)
	gen eight_o_clock = (strpos(product,"EIGHT O CLOCK")>0)
	gen seattles_best = (strpos(product,"SEATTLES BEST")>0)
	gen don_francisco = (strpos(product,"DON FRANCISCO")>0)
	gen new_england = (strpos(product,"NEW ENGLAND")>0)
	gen dunkin = (strpos(product,"DUNKIN")>0)
	gen chock = (strpos(product,"CHOCK FULL")>0)
	gen peets = (strpos(product,"PEETS")>0)
	gen nescafe = (strpos(product,"NESCAFE")>0)
	
	egen other = rowtotal(private-nescafe)
	replace other = 1-other
	
	drop product
	compress
	
** Create variables
	merge m:1 monthid using cpi.dta
	drop _merge
	
	gen ppvol = (dollars / (units * vol_eq))  / cpi * 100
	gen ppserv = ppvol
	replace ppserv = ppserv / 3.2 if strpos(l2,"INSTANT")>0
	gen logp = log(ppserv)
	
	drop units vol_eq monthid year month l2
	compress
	
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5

*** Summaries
	summarize ppvol, detail
	
	foreach var of varlist private-other {
		summarize ppvol if `var' == 1, detail
}
	
*** Brand prices
	cd "\Results"

	foreach var of varlist wm_lt5 {	
		reghdfe logp enter `var', a(i.mkt#i.upc#i.week id) cluster(stores) keepsing
			outreg2 using final_coffee, excel
		reghdfe logp enter c.`var'#c.(private-other), a(i.mkt#i.upc#i.week id) cluster(stores) keepsing
			outreg2 using final_coffee, excel
		}
		
*** Brand revenues
	gen brand=.
	local j=0
	foreach var of varlist private-other {
		replace brand = `j'+1 if `var'==1
		local j=`j'+1
		}
	
	gen revenue = dollars / cpi * 100
	
	collapse (sum) revenue, by(stores brand weekid wm enter mkt wm_1-wm_11 treat_nwm wm_lt*)
	
	egen storesbrand = group(stores brand)
	drop if storesbrand==.
	xtset storesbrand weekid
	
	gen logrev = log(revenue)
	
	compress
		
	foreach var of varlist wm_lt5 {
		reghdfe logrev enter `var' c.weekid#i.brand c.weekid#c.weekid#i.brand c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, a(weekid storesbrand) cluster(stores) keepsing
			outreg2 using final_coffee_rev, excel
		reghdfe logrev enter c.`var'#i.brand c.weekid#i.brand c.weekid#c.weekid#i.brand c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, a(weekid storesbrand) cluster(stores) keepsing
			outreg2 using final_coffee_rev, excel
		}	
